require( "scripts/game/deftasks.lua" );
require( "scripts/game/deftime.lua" );
-- class 
GameObject = {
--  
    Params = {
        ID="ground";
        width=3;
        height=1;
        health=5000;  -- 
        GridData= { 1, 1,1 };   -- do not change this parameter
        emotion=4;    -- do not change this parameter
        Impatience = 60; -- ammount of health that dissapers each second
        RandomTasks=3;
        group=3;
        --start_with_hearts = 4;   --    - 
        next_product = "tomato";  --     (tomato,corn,pumpkin)
    };
    ActivePoints = { 
        tools = { 
                   { {}, 1,-1,0,  0,  1,-1,0 };
                   }; 
        weeding = { 
                   { {}, 1,-1,0,  0,  1,-1,0 };
                   }; 
    };
    Objects = {};
    --     
    Tasks = {
        tools = { FuncName="PlantTaskExecute", timer=1, time_tick=100, restore_health=1000, not_need_action=0 }; --not_need_action=1 };   
        weeding = { FuncName="WeedingTaskExecute", timer=1, time_tick=100, restore_health=1000, not_need_action=1 }; --not_need_action=1 };   
    };
    --     
    Triggers = {
        Anger = {FuncName="AngerTriger", NotRunWhen={"tools","weeding"},active = 1 }
    };
    --      
    InitActiveTasks = {};
    --      
    InitExpectedTasks = {};
    -- RandomTasks=3     
    Cycle = {
        index=0;
        index_sleep=0;
        max_index = 0;
    };
};
life_cycle = {
    { "weeding", 5 };
    { "tools", 50000 };
};

function GameObject:Get()
    return self;
end


--        
function OnInit()
--    
    aInitObject = GameObject:Get();
    OnInitHealth();
end


function GetParams()
    aObj = GameObject:Get();   
    return aObj.Params;
end

function PlantTaskExecute()
    aObj = GameObject:Get();   
    SleepAfterTaskCycle();
    CPP_SetVisPrefix("");
    CPP_SetAnimState("plant_tablet_"..aObj.Params.next_product);
    CPP_SetAnimState("hide_heards");
    aObj.Triggers.Anger.active = 0;
    return 0;
end

function WeedingTaskExecute()
    aObj = GameObject:Get();
    CPP_SetAnimState("after_weeding");
    SleepAfterTaskCycle();
    return 0;
end

-- 
function AngerTriger()
    aObj = GameObject:Get();
    if (aObj.Triggers.Anger.active == 0)  then return; end;
    aObj.Params.health = aObj.Params.health - aObj.Params.Impatience;
    CPP_OnHealthChanged(aObj.Params.health);    
    if(aObj.Params.health<0)then aObj.Params.health = 0; end;   
end

function OnNextTask(aPrevTask, aNextTask)
    if (aNextTask=="tools") then        
        aObj = GameObject:Get();
        CPP_SetVisPrefix(aObj.Params.next_product);
    end;
end
